% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/calendar-gregorian.R,
%   R/calendar-julian.R
\docType{methods}
\name{as_year}
\alias{as_year}
\alias{as_year-method}
\alias{as_year,numeric,GregorianCalendar-method}
\alias{as_year,numeric,JulianCalendar-method}
\title{Year Conversion from \emph{Rata Die}}
\usage{
as_year(object, calendar, ...)

\S4method{as_year}{numeric,GregorianCalendar}(object, calendar, decimal = TRUE, ...)

\S4method{as_year}{numeric,JulianCalendar}(object, calendar, decimal = FALSE, ...)
}
\arguments{
\item{object}{A \code{\linkS4class{RataDie}} object (see \code{\link[=fixed]{fixed()}}).}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{...}{Currently not used.}

\item{decimal}{A \code{\link{logical}} scalar: should decimal years be returned?
If \code{FALSE}, the decimal part is dropped.}
}
\value{
A \code{\link{numeric}} vector of (decimal) years.
}
\description{
Year Conversion from \emph{Rata Die}
}
\examples{
## R 1.0.0
(y <- fixed(year = 2000, month = 02, day = 29, calendar = CE()))
as_date(y, calendar = CE())
as_year(y, calendar = CE())

## Create a vector of years BP (Gregorian)
## (every two years starting from 2000 BP)
(years <- seq(from = 2000, by = -2, length.out = 10))
## Convert years to rata die
(rd <- fixed(years, calendar = BP()))
## Convert back to Gregorian years BP
as_year(rd, calendar = BP())

## More convenient
(rd <- fixed_from_BP(years))
fixed_to_BP(rd)
}
\references{
Reingold, E. M. and Dershowitz, N. (2018). \emph{Calendrical Calculations:
The Ultimate Edition}. Cambridge University Press.
\doi{10.1017/9781107415058}.
}
\seealso{
Other fixed date tools: 
\code{\link{arithmetic}},
\code{\link{as_date}()},
\code{\link{as_decimal}()},
\code{\link{as_fixed}()},
\code{\link{fixed}()},
\code{\link{fixed_gregorian}},
\code{\link{fixed_julian}},
\code{\link{format}()},
\code{\link{pretty}()}
}
\author{
N. Frerebeau
}
\concept{fixed date tools}
