% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_extract.R
\name{av_extract_df}
\alias{av_extract_df}
\alias{av_extract_fx}
\alias{av_extract_analytics}
\title{Extract data from Alpha Vantage returned data}
\usage{
av_extract_df(indta, grepstring = "", melt = FALSE)

av_extract_fx(indta)

av_extract_analytics(indta, separate_vars = FALSE)
}
\arguments{
\item{indta}{A data.table as returned by av_get()}

\item{grepstring}{select which variable (data item) to unnest in data.table returned from av_get_pf}

\item{melt}{Return data in melted/normalized form}

\item{separate_vars}{(default : FALSE)  separate out multiple levels of variable names into new keys}
}
\value{
Extracted data.tables for nested data returned from \code{\link[=av_get_pf]{av_get_pf()}}, If \code{grepstring} is not specified, first nested table is returned. \code{\link[=av_extract_fx]{av_extract_fx()}} returns a shortened data.table with FX quotes.
}
\description{
\code{av_extract_df()} pulls out nested data.frames from mixed data returned by  \code{\link[=av_get_pf]{av_get_pf()}}
\code{av_extract_fx()} returns a simplified FX quote in data.table formfrom \code{\link[=av_get_pf]{av_get_pf()}} calls.
\code{av_extract_analytics()} returns melted data.table from calls to \code{av_get_pf("ANALYTICS_FIXED_WINDOW")} or \code{av_get_pf("ANALYTICS_SLIDING_WINDOW")}
}
\details{
\code{\link[=av_get_pf]{av_get_pf()}} frequently returns a nested data.table, or a structure with nested data.frames.  These are utilities functions to extract, filter and summarize returned values.
}
\examples{
\dontrun{
av_get_pf("","MARKET_STATUS")  |> av_extract_df()
av_get_pf("","TOP_GAINERS_LOSERS") |> av_extract_df("top_losers")
av_get_pf("USD/BRL","CURRENCY_EXCHANGE_RATE") |> av_extract_fx()
av_get_pf(c("ORCL","IBM"),"ANALYTICS_FIXED_WINDOW") |> av_extract_analytics(separate_vars=TRUE)
}

}
\seealso{
\code{\link[=av_get_pf]{av_get_pf()}}, \code{\link[=av_grep_opts]{av_grep_opts()}}
}
