% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amapro.R
\name{am.cmd}
\alias{am.cmd}
\title{Run a command}
\usage{
am.cmd(id, cmd = NULL, trgt = NULL, ...)
}
\arguments{
\item{id}{A map widget from \link{am.init} or a proxy from \link{am.proxy}}

\item{cmd}{AMap command name string, like 'setFitView', 'setMapStyle', etc.}

\item{trgt}{A target's name string, or 'map' for the map itself.}

\item{...}{command attributes from AMap API. \cr
For AMap commands starting with 'get' there are two \emph{amapro} attributes 'f' and 'r'.\cr
'f' is an optional JS function to manipulate the data received, \cr
'r' is the name of the Shiny variable receiving the data}
}
\value{
A map or a map proxy
}
\description{
Execute a command on a target element
}
\details{
\emph{am.cmd} provides interaction with the map.\cr
Commands are sent to the map itself, or to objects inside or outside it.\cr
AMap built-in objects have predefined set of commands listed in the API.
Commands can modify an object (setZoom), but also get data from it (getCenter).\cr
\emph{amapro} introduces its own commands like \emph{set}, \emph{addTo} or \emph{code}, described in the \link{Introduction}.
}
\examples{
if (interactive()) {
  # 'position' and 'content' are InfoWindow parameters from AMap API
  am.init() |> 
  am.cmd('set', 'InfoWindow', position=c(116.6, 40), content='Beijing')
  
  am.proxy("plot") |>
    am.cmd('getLayers', 'map',
           f= 'function(yy) { return yy.map(x => { return x.CLASS_NAME;}); }',
           r= 'result1')
}
}
\seealso{
\link{am.init} code example and \link{Introduction}
}
