% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcci.R
\name{mcci}
\alias{mcci}
\title{Compute Monte Carlo Confidence Intervals}
\usage{
mcci(
  d = NULL,
  se = NULL,
  mediation = FALSE,
  n.mcci = 10000,
  sig.level = 0.05,
  sig.adjusted = TRUE,
  two.tailed = TRUE,
  seed = 123,
  eq.bd = NULL,
  xlim = NULL,
  xlab = NULL,
  ylab = NULL,
  dashed.lines = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{d}{The estimated effect(s), it has a length of one, two, and four.
(1) When the length is one, it is an estimated main or moderation effect,
the MCCI compute the CI for this estimate; (2) When the length is two,
they represent two estimated effects. These two estimated effects are
main or moderation effects when \code{mediation}
is FALSE, the MCCI compute the CI for the difference of the two estimates;
These two estimated effects are the treatment-mediator and mediator-outcome
path estimates for a mediation effect when \code{mediation} is TRUE;
the MCCI compute the CI for the mediation effects. (3) When the length
is four, they represent the mediation effects in two studies in the
following order: the treatment-mediator and mediator-outcome
path estimates in studies (groups) 1 and 2.}

\item{se}{The corresponding standard error(s) for parameter \code{d}.}

\item{mediation}{Logical; \code{d} and \code{se} represent
parameters for a mediation effect if TRUE; \code{d} and \code{se}
represent parameters for a main or moderation effect if FALSE;
default value is FALSE.}

\item{n.mcci}{The number of draws for the MCCI method. Default is 10,000.}

\item{sig.level}{The significance level. Default is .05.}

\item{sig.adjusted}{Logical; use Bonferroni correction (i.e., dividing
the original significance level by the number of tests) if TRUE,
otherwise not; default value is TRUE.}

\item{two.tailed}{Logical of two tailed test for difference test. Default is TRUE.}

\item{seed}{Random seed for replication, default is 123.}

\item{eq.bd}{The limit of the equivalence bounds for an equivalence test.
Default is the MCCI for the equivalence test.
It can be specified in the arguments as eq.bd = a positive number or
eq.bd = c(lower bound #, upper bound #).}

\item{xlim}{The limits set for the x-axis in the plot.
Default is the MCCI for the difference test. It can be
 specified in the arguments as xlim = c(lower #, higher #).}

\item{xlab}{The label for the x-axis in the plot.
Default is "Differences in Effects".}

\item{ylab}{The label for the y-axis in the plot.
Default is NULL.}

\item{dashed.lines}{Logical of whether dashed lines of equivalence
bounds and zero should be added in the plot. Default is TRUE.}

\item{verbose}{Logical; print the process if TRUE,
otherwise not; default value is TRUE.}
}
\value{
The results of moderation analysis and equivalence tests
    using the MCCI method. It will also provide a plot for
    the MCCIs.
}
\description{
Compute Monte Carlo confidence intervals (MCCIs) for the
     difference and equivalence tests.
}
\examples{
   library(anomo)
# 1. Compute MCCIs for main or moderation effects-----
   # 1.1. Compute MCCIs for one main or moderation effect from one study
   myci <- mcci(d = .1, se = .02); myci$out
   # 1.2 Compute MCCIs for differences in two main (or moderation) effects
   myci <- mcci(d = c(0.1, 0.15), se = c(.02, 0.01)); myci$out
   # 1.3 Compute MCCIs for differences across five main (or moderation) effects
   myci <- mcci(d = c(0.10, 0.15, 0.20, 0.25, 0.30),
                se = c(0.01, 0.01, 0.02, 0.02, 0.03))
   myci$out

# 2. Compute MCCIs for mediation effects
   # 2.1. Compute MCCIs for an estimated mediation effect
   myci <- mcci(d = c(.1, 0.15), se = c(.02, 0.01), mediation = TRUE)
   myci$out
   # 2.1. Compute MCCIs for differences in two mediation effects
   myci <- mcci(d = c(0.30, 0.50, 0.33, 0.55),
                se = c(0.02, 0.01, 0.02, 0.03), mediation = TRUE)
                myci$out
# 3. Explicitly specify other parameters
   myci <- mcci(d = .05, se = .02, eq.bd = 0.1) # equivalence bounds
   myci <- mcci(d = .05, se = .02, xlim = c(-0.15, 0.15)) # Range of x-axis
}
