% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{separate_star_column}
\alias{separate_star_column}
\title{Add columns that separate significance stars from numbers}
\usage{
separate_star_column(
  data,
  ...,
  superscript = TRUE,
  star = "\\\\*",
  star_replace = "\\\\\\\\*"
)
}
\arguments{
\item{data}{data.frame or tibble}

\item{...}{Column name or tidyselect function. Select columns}

\item{superscript}{make stars superscript}

\item{star}{character to use for stars (default: "\\*")}

\item{star_replace}{character to replace stars with (default: "\\\\*")}
}
\value{
data.frame or tibble
}
\description{
Add columns that separate significance stars from numbers
}
\examples{
tibble::tibble(x = c(".45", ".58*", ".68**"),
               y = c(1,2,3),
               z = 4:6) |>
               separate_star_column(x)
}
