% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uoc_psych_homework_formats.R
\name{uoc_psych_homework_pdf}
\alias{uoc_psych_homework_pdf}
\title{University of Cologne Psychology Homework}
\usage{
uoc_psych_homework_pdf(
  fig_caption = TRUE,
  number_sections = FALSE,
  toc = FALSE,
  keep_tex = FALSE,
  md_extensions = NULL,
  includes = NULL,
  ...
)
}
\arguments{
\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{number_sections}{\code{TRUE} to number section headings}

\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF.
Note that this argument does not control whether to keep the auxiliary
files (e.g., \file{.aux}) generated by LaTeX when compiling \file{.tex} to
\file{.pdf}. To keep these files, you may set \code{options(tinytex.clean =
FALSE)}.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the
\code{\link[rmarkdown]{rmarkdown_format}} for additional details.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{...}{Further arguments to pass to
\code{\link[bookdown]{pdf_document2}} or
\code{\link[bookdown]{word_document2}}.}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.
}
\description{
Template for homework in psychology at the University of Cologne in PDF
format.
}
\details{
When creating PDF documents the YAML option \code{classoption} is passed
to the class options of the LaTeX apa6 document class. In this case,
additional options are available. Refer to the \code{apa6} document class
\href{ftp://ftp.fu-berlin.de/tex/CTAN/macros/latex/contrib/apa6/apa6.pdf}{documentation}
to find out about class options such as paper size.
}
\examples{
\dontrun{
# Render skeleton
skeleton_path <- file.path(tempdir(), "homework_skeleton.Rmd")

rmarkdown::draft(
  skeleton_path
  , system.file(
    "rmarkdown", "templates", "uoc-psych-homework"
    , package = "apathe"
  )
  , create_dir = FALSE
  , edit = FALSE
)

rmarkdown::render(skeleton_path, quiet = TRUE)
}
}
\seealso{
\link{uoc_psych_thesis_pdf}, \code{\link[bookdown:html_document2]{bookdown::pdf_document2()}}, \code{\link[bookdown:html_document2]{bookdown::word_document2()}}
}
