% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-group-content.R
\name{content}
\alias{content}
\alias{arc_group_content}
\alias{arc_user_content}
\title{Portal Content Items}
\usage{
arc_group_content(group, host = arc_host(), token = arc_token())

arc_user_content(user, host = arc_host(), token = arc_token())
}
\arguments{
\item{group}{a scalar character of the group ID or a \code{PortalGroup} object created using \code{\link[=arc_group]{arc_group()}}}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}

\item{user}{a scalar character of the username or a \code{PortalUser} object created using \code{\link[=arc_user]{arc_user()}}}
}
\value{
a \code{data.frame} of content item metadata
}
\description{
For a given user or group, returns a data.frame of all content items owned by them.
}
\examples{
\dontrun{
library(arcgis)

# authenticate
set_arc_token(auth_user())

# get your own content items
self <- arc_user_self()
arc_user_content(self$username)

# get a specific group's items
arc_group_content("2f0ec8cb03574128bd673cefab106f39")
}
}
\references{
\itemize{
\item \href{https://developers.arcgis.com/rest/users-groups-and-items/group-content/}{Group Content API Reference}
\item \href{https://developers.arcgis.com/rest/users-groups-and-items/user-content/}{User Content API Reference}
}
}
\keyword{content}
\keyword{portal}
