% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-token.R
\name{arc_token}
\alias{arc_token}
\alias{set_arc_token}
\alias{unset_arc_token}
\alias{obj_check_token}
\alias{check_token_has_user}
\title{Manage authorization tokens}
\usage{
arc_token(token = "ARCGIS_TOKEN")

set_arc_token(token, ...)

unset_arc_token(token = NULL)

obj_check_token(token, call = rlang::caller_env())

check_token_has_user(token, call = rlang::caller_env())
}
\arguments{
\item{token}{for \code{arc_token()}, the name of a token to fetch. For \code{set_arc_token()},
it is an \code{httr2_token} that will be set. For \code{unset_arc_token()}, a character
vector of token names to be unset.}

\item{...}{named arguments to set \code{httr2_token}. Must be valid names and must be an \code{httr2_token}.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\description{
These functions are used to set, fetch, and check authorization tokens.
}
\details{
It is possible to have multiple authorization tokens in one session. These
functions assist you in managing them.

\code{arc_token()} is used to fetch tokens by name. The default token is \code{ARCGIS_TOKEN}.
However, they can be any valid character scalar. \code{set_arc_token()} will create
store a token with the name \code{ARCGIS_TOKEN}. However, you can alternatively
set the tokens by name using a key-value pair. The key is what you would pass
to \code{arc_token()} to fetch the \code{httr2_token} object. To remove a token that has
been set, use \code{unset_arc_token()}.

\code{obj_check_token()} is a developer oriented function that can be used to check
if an object is indeed an \code{httr2_token}. To check if a token has expired,
\code{\link[=validate_or_refresh_token]{validate_or_refresh_token()}} will do so.

\code{check_token_has_user()} is a developer oriented function that checks to see
if a token has a \code{username} field associated with it.

For developers:

\code{set_arc_token()} uses a package level environment to store the tokens. The
tokens are fetched from the environment using \code{arc_token()}.
}
\examples{
# create fake tokens
token_a <- httr2::oauth_token("1234", arcgis_host = arc_host())
token_b <- httr2::oauth_token("abcd", arcgis_host = arc_host())

# set token to the default location
set_arc_token(token_a)

# fetch token from the default location
arc_token()

# set token by name
set_arc_token(org_a = token_a, org_b = token_b)

# fetch token by name
arc_token("org_a")
arc_token("org_b")

# unset tokens
unset_arc_token()
unset_arc_token(c("org_a", "org_b"))
}
