% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-globals.R
\name{min_max_scale}
\alias{min_max_scale}
\title{Min–max scale continuous variables}
\usage{
min_max_scale(x)
}
\arguments{
\item{x}{Numeric vector. Continuous variable(s) to scale.}
}
\value{
Numeric vector of the same length as \code{x}, scaled to [0, 1].
}
\description{
Scales numeric vectors to the [0, 1] range using the formula:
\deqn{(x - \min(x)) / (\max(x) - \min(x))}
}
\details{
This is the recommended preprocessing step for continuous variables
prior to VAE training with AutoTab, ensuring all inputs are on
comparable scales to binary and categorical features.
\itemize{
\item The transformation is \strong{performed column-wise} when applied
to data frames.
}
}
\examples{
x <- c(10, 20, 30)
min_max_scale(x)

# Apply to multiple columns
data <- data.frame(age = c(20, 40, 60), income = c(3000, 5000, 7000))
Continuous_MinMaxScaled = as.data.frame(lapply(data, min_max_scale))


}
\seealso{
\code{\link[=extracting_distribution]{extracting_distribution()}}, \code{\link[=set_feat_dist]{set_feat_dist()}}, \code{\link[=VAE_train]{VAE_train()}}
}
