% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_launch_template}
\alias{ec2_create_launch_template}
\title{Create Launch Template}
\usage{
ec2_create_launch_template(
  LaunchTemplateName,
  LaunchTemplateData,
  DryRun = NULL,
  ClientToken = NULL,
  VersionDescription = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{LaunchTemplateName}{Character. A name for the launch template.}

\item{LaunchTemplateData}{Object. The information for the launch template.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{VersionDescription}{Character. A description for the first version of the launch template.[optional]}

\item{TagSpecification}{List. The tags to apply to the launch template during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Creates a launch template. A launch template
contains the parameters to launch an instance. When you launch an
instance using RunInstances, you can specify a launch template instead
of providing the launch parameters in the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html}{Launching an instance from a launch template}in
the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{LaunchTemplateName}{

A name for the launch
template.
}

\section{LaunchTemplateData}{

The information for the launch
template.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.
}

\section{VersionDescription}{

A description for the first version of the launch
template.
}

\section{TagSpecification}{

The tags to apply to the launch template
during creation.
}

