% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{getChildren}
\alias{getChildren}
\title{Generate Child and Parent Node Relationships}
\usage{
getChildren(data)
}
\arguments{
\item{data}{A data frame with tree structure, including `iteration`,
`treeNum`, `node`, and `depth` columns, along with a `terminal` indicator.}
}
\value{
The modified data frame with `childLeft`, `childRight`, and `parent` columns added,
        detailing the tree's parent-child node relationships.
}
\description{
Populates `childLeft`, `childRight`, and `parent` columns in the dataset to establish
parent-child relationships between nodes based on tree structure.
}
\examples{
data("tree_data_example")
# Create Terminal Column
tree_data_example <- transform(tree_data_example,
                               terminal = ifelse(is.na(var),
                               TRUE,
                               FALSE))
# Get depths
depthList <- lapply(split(tree_data_example, ~treeNum + iteration),
                    function(x) cbind(x, depth = node_depth(x)-1))
# Turn into data frame
tree_data_example <- dplyr::bind_rows(depthList, .id = "list_id")
# Add node number sequntially
tree_data_example$node <- with(tree_data_example,
                               ave(seq_along(iteration),
                               list(iteration, treeNum),
                               FUN = seq_along))
# get children
getChildren(data = tree_data_example)

}
