% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_diagnostics_summary.R
\name{mcmc_diagnostics_summary}
\alias{mcmc_diagnostics_summary}
\title{MCMC Diagnostics Summary}
\usage{
mcmc_diagnostics_summary(model, rhat_threshold = 1.01, ess_threshold = 400)
}
\arguments{
\item{model}{A fitted brmsfit object}

\item{rhat_threshold}{Numeric. Threshold for R-hat warning (default: 1.01)}

\item{ess_threshold}{Numeric. Threshold for ESS warning (default: 400)}
}
\value{
A list of class \code{mcmc_diagnostics} containing:
\itemize{
\item \code{rhat_issues}: Parameters with high R-hat
\item \code{ess_issues}: Parameters with low ESS
\item \code{divergences}: Number of divergent transitions
\item \code{tree_depth}: Number of iterations hitting max tree depth
\item \code{summary_table}: Tibble of all diagnostics per parameter
\item \code{converged}: Logical summary of overall convergence
}
}
\description{
Provides a comprehensive summary of MCMC convergence diagnostics,
including R-hat, Effective Sample Size (ESS), and NUTS-specific
issues like divergent transitions and tree depth saturation.
}
