% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{LogNormalAcquisitionParams}
\alias{LogNormalAcquisitionParams}
\title{Log-Normal Acquisition Parameters}
\usage{
LogNormalAcquisitionParams(
  time = Param(0, 0),
  constant = Param(0.001, 1),
  log_tot_inpat = Param(-1, 0),
  log_col = Param(1, 0),
  col = Param(0, 0),
  abx_col = Param(0, 0),
  onabx = Param(0, 0),
  everabx = Param(0, 0)
)
}
\arguments{
\item{time}{Time parameter (index 0)}

\item{constant}{Constant parameter (index 1)}

\item{log_tot_inpat}{Log total in-patients parameter (index 2)}

\item{log_col}{Log number colonized parameter (index 3)}

\item{col}{Number colonized parameter (index 4)}

\item{abx_col}{Number abx colonized parameter (index 5)}

\item{onabx}{Susceptible patient on Abx effect (index 6)}

\item{everabx}{Susceptible patient ever on Abx effect (index 7)}
}
\value{
An unnamed list of 8 parameters in the correct order for LogNormalAbxICP.
}
\description{
Acquisition parameters for the log-normal model (LogNormalAbxICP).
This model has 8 acquisition parameters accessed by index in C++.
Note: When accessed via setupLogNormalICPAcquisition, parameters are set by index,
so this returns an unnamed list where position matters.
}
\examples{
LogNormalAcquisitionParams()
}
