% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{newModelExport}
\alias{newModelExport}
\title{Create a new model object}
\usage{
newModelExport(modelParameters, verbose = FALSE)
}
\arguments{
\item{modelParameters}{List of model parameters, including:
\itemize{
\item \code{modname} Name of the model (e.g., "LogNormalModel", "LinearAbxModel", "LinearAbxModel2", "MixedModel")
\item \code{nstates} Number of states in the model
\item \code{nmetro} Number of metropolis steps
\item \code{forward} Forward parameter
\item \code{cheat} Cheat parameter
}}

\item{verbose}{Print progress messages (default: false)}
}
\value{
A list containing the initialized model parameters:
\itemize{
\item \code{Insitu} - In situ parameters
\item \code{SurveillanceTest} - Surveillance test parameters
\item \code{ClinicalTest} - Clinical test parameters
\item \code{OutCol} - Out of unit colonization parameters
\item \code{InCol} - In unit colonization parameters
\item \code{Abx} - Antibiotic parameters
}
}
\description{
Creates and initializes a model object based on the provided parameters.
This allows direct creation and inspection of model objects without running MCMC.
Returns a list with all model parameter values for verification.
}
