% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_quick_suggest.R
\name{bid_quick_suggest}
\alias{bid_quick_suggest}
\title{Quick UX Suggestions for R Dashboard Developers}
\usage{
bid_quick_suggest(
  problem,
  context = NULL,
  package = NULL,
  limit = 10,
  min_score = 0.7,
  quiet = NULL
)
}
\arguments{
\item{problem}{Required. A character string describing the UX problem.
Examples: "Users can't find the download button", "Information
overload on dashboard", "Mobile interface is hard to navigate".}

\item{context}{Optional. Additional context about the application or users.
This helps refine suggestions to your specific situation.}

\item{package}{Optional. Filter suggestions to specific package ("bslib",
"shiny", "reactable", "DT", "plotly", "leaflet", etc.). If NULL,
returns suggestions for all relevant packages. Note: bslib, plotly,
DT, reactable, and leaflet components work in both Shiny apps and
Quarto dashboards.}

\item{limit}{Optional. Maximum number of suggestions to return (default: 10).
Set to Inf to return all suggestions.}

\item{min_score}{Optional. Minimum relevance score 0-1 (default: 0.7).
Higher values return only the most relevant suggestions.}

\item{quiet}{Optional. Logical indicating whether to suppress informational
messages. If NULL, uses getOption("bidux.quiet", FALSE).}
}
\value{
A tibble with columns:
\item{title}{Brief actionable description of the suggestion}
\item{details}{Specific implementation guidance}
\item{components}{R dashboard component recommendations (character vector).
Components prefixed with 'shiny::' require Shiny runtime; bslib, DT,
plotly, reactable, and leaflet components work in both Shiny and Quarto
dashboards.}
\item{concept}{UX concept the suggestion is based on}
\item{score}{Relevance score (0-1, higher is more relevant)}
\item{difficulty}{Implementation difficulty (easy/moderate/advanced)}
\item{rationale}{1-2 sentence explanation of why this helps}
}
\description{
Provides a streamlined, single-step workflow for R dashboard developers who
need quick UX suggestions without going through the full 5-stage BID
framework. This function internally leverages the BID framework stages but
presents results in a simple, actionable format. Works with both Shiny
applications and Quarto dashboards.

Unlike the full BID workflow (Interpret -> Notice -> Anticipate -> Structure
-> Validate), this function provides immediate suggestions based on a problem
description. Use this for rapid prototyping or when you need quick guidance.
For comprehensive UX redesign projects, use the full BID workflow.
}
\details{
\strong{How it works:}

The function analyzes your problem description using keyword matching and
semantic analysis to:
\enumerate{
\item Identify relevant UX concepts (cognitive load, navigation, visual hierarchy, etc.)
\item Detect appropriate layout patterns (grid, card, breathable, etc.)
\item Generate ranked suggestions with specific component recommendations
\item Filter and sort by relevance score
}

\strong{Problem Analysis Keywords:}
\itemize{
\item "overload", "overwhelm", "too many" -> Cognitive Load Theory
\item "find", "search", "navigate" -> Information Scent
\item "cluttered", "messy", "disorganized" -> Visual Hierarchy
\item "mobile", "touch", "responsive" -> Fitts's Law
\item "confusing", "unclear", "complex" -> Progressive Disclosure
}

\strong{When to use this vs full BID workflow:}
\itemize{
\item Use \code{bid_quick_suggest()}: Quick fixes, prototyping, single issues
\item Use full workflow: Comprehensive redesigns, complex projects, team collaboration
}

\strong{Quarto Dashboard Compatibility:}
Component suggestions include both Shiny-specific (shiny::) and framework-agnostic
components. For static Quarto dashboards or OJS-based interactivity, focus on
bslib, DT, plotly, reactable, and leaflet suggestions. Shiny-prefixed components
require \code{server: shiny} in Quarto dashboards or a traditional Shiny app.
}
\examples{
# Basic usage
suggestions <- bid_quick_suggest(
  problem = "Users can't find the download button"
)
print(suggestions)

# With additional context
suggestions <- bid_quick_suggest(
  problem = "Dashboard has too many charts and metrics",
  context = "Financial analysts need quick insights but get overwhelmed",
  limit = 5
)

# Filter to specific package
bslib_suggestions <- bid_quick_suggest(
  problem = "Mobile interface is hard to use",
  package = "bslib",
  min_score = 0.8
)

# Navigation issues
nav_suggestions <- bid_quick_suggest(
  problem = "Users get lost in multi-tab interface",
  context = "Application has 10+ tabs with nested content"
)

# Information overload
overload_suggestions <- bid_quick_suggest(
  problem = "Too many filters and options on the sidebar",
  context = "Beginners find the interface overwhelming"
)

}
