% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_bootstrap}
\alias{pls_bootstrap}
\title{Bootstrap a PLS model}
\usage{
pls_bootstrap(
  X,
  Y,
  ncomp,
  R = 100L,
  algorithm = c("simpls", "nipals", "kernelpls", "widekernelpls"),
  backend = "arma",
  conf = 0.95,
  seed = NULL,
  type = c("xy", "xt"),
  parallel = c("none", "future"),
  future_seed = TRUE,
  return_scores = FALSE,
  ...
)
}
\arguments{
\item{X}{Predictor matrix.}

\item{Y}{Response matrix or vector.}

\item{ncomp}{Number of components.}

\item{R}{Number of bootstrap replications.}

\item{algorithm}{Backend algorithm ("simpls", "nipals", "kernelpls" or
"widekernelpls").}

\item{backend}{Backend argument passed to the fitting routine.}

\item{conf}{Confidence level.}

\item{seed}{Optional seed.}

\item{type}{Character; bootstrap scheme, e.g. \code{"pairs"}, \code{"residual"}, or \code{"parametric"}.}

\item{parallel}{Logical or character; if \code{TRUE} or one of
\code{c("sequential", "multisession", "multicore")}, uses the future framework.}

\item{future_seed}{Logical or integer; forwarded to \code{future.seed} for
reproducible parallel streams.}

\item{return_scores}{Logical; if \code{TRUE}, return component scores for each replicate
(may be large).}

\item{...}{Additional arguments forwarded to \code{\link[=pls_fit]{pls_fit()}}.}
}
\value{
A list with bootstrap estimates and summaries.
}
\description{
Draw bootstrap replicates of a fitted PLS model, refitting on each resample.
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
pls_bootstrap(X, y, ncomp = 2, R = 20)
}
