% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_pls_cox_transform.R
\name{big_pls_cox_transform}
\alias{big_pls_cox_transform}
\title{Transform new data to PLS–Cox scores}
\usage{
big_pls_cox_transform(
  X,
  means,
  sds,
  weights,
  loadings,
  comps = seq_len(ncol(weights))
)
}
\arguments{
\item{X}{New data: a numeric matrix or a \code{bigmemory::big.matrix}.}

\item{means}{Column means used to center the original predictors.}

\item{sds}{Column standard deviations used to scale the original predictors.}

\item{weights}{PLS weight matrix (p x ncomp) from a fitted model.}

\item{loadings}{PLS loading matrix (p x ncomp) from a fitted model.}

\item{comps}{Integer vector of component indices to return (1-based).}
}
\value{
A numeric matrix of scores with one row per observation in \code{X}
and one column per requested component.
}
\description{
Project new observations onto previously fitted PLS–Cox components.
}
