% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDR.R
\name{computeDR}
\alias{computeDR}
\title{Compute deviance residuals}
\usage{
computeDR(
  time,
  time2,
  event,
  type,
  origin,
  typeres = "deviance",
  collapse,
  weighted,
  scaleY = TRUE,
  plot = FALSE,
  engine = c("survival", "cpp", "qcpp"),
  method = c("efron", "breslow"),
  X = NULL,
  coef = NULL,
  eta = NULL,
  center = NULL,
  scale = NULL
)
}
\arguments{
\item{time}{for right censored data, this is the follow up time. For
interval data, the first argument is the starting time for the interval.}

\item{time2}{The status indicator, normally 0=alive, 1=dead. Other choices
are \code{TRUE/FALSE} (\code{TRUE} = death) or 1/2 (2=death). For interval
censored data, the status indicator is 0=right censored, 1=event at
\code{time}, 2=left censored, 3=interval censored. Although unusual, the
event indicator can be omitted, in which case all subjects are assumed to
have an event.}

\item{event}{ending time of the interval for interval censored or counting
process data only. Intervals are assumed to be open on the left and closed
on the right, \code{(start, end]}. For counting process data, event
indicates whether an event occurred at the end of the interval.}

\item{type}{character string specifying the type of censoring. Possible
values are \code{"right"}, \code{"left"}, \code{"counting"},
\code{"interval"}, or \code{"interval2"}. The default is \code{"right"} or
\code{"counting"} depending on whether the \code{time2} argument is absent
or present, respectively.}

\item{origin}{for counting process data, the hazard function origin. This
option was intended to be used in conjunction with a model containing time
dependent strata in order to align the subjects properly when they cross
over from one strata to another, but it has rarely proven useful.}

\item{typeres}{character string indicating the type of residual desired.
Possible values are \code{"martingale"}, \code{"deviance"}, \code{"score"},
\code{"schoenfeld"}, \code{"dfbeta"}, \code{"dfbetas"}, and
\code{"scaledsch"}. Only enough of the string to determine a unique match is
required.}

\item{collapse}{vector indicating which rows to collapse (sum) over. In
time-dependent models more than one row data can pertain to a single
individual. If there were 4 individuals represented by 3, 1, 2 and 4 rows of
data respectively, then \code{collapse=c(1,1,1,2,3,3,4,4,4,4)} could be used
to obtain per subject rather than per observation residuals.}

\item{weighted}{if \code{TRUE} and the model was fit with case weights, then
the weighted residuals are returned.}

\item{scaleY}{Should the \code{time} values be standardized ?}

\item{plot}{Should the survival function be plotted ?}

\item{engine}{Either \code{"survival"} (default) to call
\code{\link[survival:coxph]{survival::coxph()}} or \code{"cpp"} to use the C++ implementation.}

\item{method}{Tie handling to use with \code{engine = "cpp"}: either
\code{"efron"} (default) or \code{"breslow"}.}

\item{X}{Optional design matrix used to compute the linear predictor when
\code{engine = "cpp"}. Supports base matrices, data frames, and
\code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} objects.}

\item{coef}{Optional coefficient vector associated with \code{X} when
\code{engine = "cpp"}.}

\item{eta}{Optional precomputed linear predictor passed directly to the C++
engine.}

\item{center, scale}{Optional centring and scaling vectors applied to \code{X}
before computing the linear predictor with the C++ engine.}
}
\value{
Residuals from a null model fit. When \code{engine = "cpp"}, the returned
vector has attributes \code{"martingale"}, \code{"cumhaz"}, and
\code{"linear_predictor"}.
}
\description{
This function computes deviance residuals from a null Cox model. By default
it delegates to \code{\link[survival:coxph]{survival::coxph()}}, but a high-performance C++ engine is
also available for large in-memory or \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} design
matrices.
}
\examples{

data(micro.censure, package = "bigPLScox")

Y_train_micro <- micro.censure$survyear[1:80]
C_train_micro <- micro.censure$DC[1:80]

Y_DR <- computeDR(Y_train_micro,C_train_micro)
Y_DR <- computeDR(Y_train_micro,C_train_micro,plot=TRUE)

Y_cpp <- computeDR(
  Y_train_micro,
  C_train_micro,
  engine = "cpp",
  eta = rep(0, length(Y_train_micro))
)

Y_qcpp <- computeDR(
  Y_train_micro,
  C_train_micro,
  engine = "qcpp"
)

}
\references{
Bastien, P., Bertrand, F., Meyer, N., and Maumy-Bertrand, M.
(2015). Deviance residuals-based sparse PLS and sparse kernel PLS for
binary classification and survival analysis. \emph{BMC Bioinformatics}, 16, 211.

Therneau, T.M., Grambsch, P.M. (2000). \emph{Modeling Survival Data: Extending the
Cox Model}. Springer.
}
\seealso{
\code{\link[survival]{coxph}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
