% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\docType{class}
\name{BIOMOD.ensemble.models.out}
\alias{BIOMOD.ensemble.models.out}
\alias{BIOMOD.ensemble.models.out-class}
\alias{show,BIOMOD.ensemble.models.out-method}
\title{\code{BIOMOD_EnsembleModeling()} output object class}
\usage{
\S4method{show}{BIOMOD.ensemble.models.out}(object)
}
\arguments{
\item{object}{a \code{\link{BIOMOD.ensemble.models.out}} object}
}
\description{
Class returned by \code{\link{BIOMOD_EnsembleModeling}}, and used by 
\code{\link{BIOMOD_LoadModels}}, \code{\link{BIOMOD_PresenceOnly}} and 
\code{\link{BIOMOD_EnsembleForecasting}}
}
\section{Slots}{

\describe{
\item{\code{modeling.id}}{a \code{character} corresponding to the name (ID) of the
simulation set}

\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{expl.var.names}}{a \code{vector} containing names of explanatory
variables}

\item{\code{data.type}}{a \code{character} corresponding to the data type}

\item{\code{models.out}}{a \code{\link{BIOMOD.stored.models.out-class}} object
containing informations from \code{\link{BIOMOD_Modeling}} object}

\item{\code{em.by}}{a \code{character} corresponding to the way kept models have
been combined to build the ensemble models, must be among
\code{PA+run}, \code{PA+algo}, \code{PA},
\code{algo}, \code{all}}

\item{\code{em.computed}}{a \code{vector} containing names of ensemble models}

\item{\code{em.failed}}{a \code{vector} containing names of failed ensemble models}

\item{\code{em.models_kept}}{a \code{list} containing single models for each ensemble model}

\item{\code{models.evaluation}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing models evaluation}

\item{\code{variables.importance}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing variables importance}

\item{\code{models.prediction}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing models predictions}

\item{\code{models.prediction.eval}}{a \code{\link{BIOMOD.stored.data.frame-class}}
object containing models predictions for evaluation data}

\item{\code{link}}{a \code{character} containing the file name of the saved object}

\item{\code{call}}{a \code{language} object corresponding to the call used to obtain the object}
}}

\examples{
showClass("BIOMOD.ensemble.models.out")

## ----------------------------------------------------------------------- #
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                       resp.var = myResp,
                                       resp.xy = myRespXY,
                                       expl.var = myExpl)

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      CV.strategy = 'random',
                                      CV.nb.rep = 2,
                                      CV.perc = 0.8,
                                      OPT.strategy = 'bigboss',
                                      metric.eval = c('TSS', 'AUCroc'),
                                      var.import = 3,
                                      seed.val = 42)
}


## ----------------------------------------------------------------------- #
# Model ensemble models
myBiomodEM <- BIOMOD_EnsembleModeling(bm.mod = myBiomodModelOut,
                                      models.chosen = 'all',
                                      em.by = 'all',
                                      em.algo = c('EMmean', 'EMca'),
                                      metric.select = c('TSS'),
                                      metric.select.thresh = c(0.7),
                                      metric.eval = c('TSS', 'AUCroc'),
                                      var.import = 3,
                                      seed.val = 42)
myBiomodEM


}
\seealso{
\code{\link{BIOMOD_EnsembleModeling}}, \code{\link{BIOMOD_LoadModels}}, 
\code{\link{BIOMOD_PresenceOnly}}, \code{\link{bm_VariablesImportance}}, 
\code{\link{bm_PlotEvalMean}}, \code{\link{bm_PlotEvalBoxplot}}, 
\code{\link{bm_PlotVarImpBoxplot}}, \code{\link{bm_PlotResponseCurves}}

Other Toolbox objects: 
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.rangesize.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
