#' blacksea Bayesian Network
#'
#'
#' Analyzing collision, grounding, and sinking accidents occurring in the Black Sea utilizing HFACS and Bayesian networks.
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network to analyze the marine accidents. The probabilities were given within the referenced paper. The vertices are:
#' \describe{
#' \item{AnchorageAreaSelection}{(Appropriate, Inappropriate);}
#' \item{CargoShiftingOrInappropriateStability}{(Yes, No);}
#' \item{CollisionAndContact}{(Yes, No);}
#' \item{COLREG}{(Not Violated, Violated);}
#' \item{CompanyManningStrategy}{(Optimum Safe Manning, Minimum Safe Manning);}
#' \item{CrewAssignment}{(Qualified Crew, Unqualified Crew);}
#' \item{DepartureFromPortInHeavyWeatherAndSeaCondition}{(Yes, No);}
#' \item{ExternalInternalCommunication}{(Adequate, Inadequate);}
#' \item{ExternalOperationalConditionsForCollisionAndContact}{(Observed, Unobserved);}
#' \item{ExternalOperationalConditionsForGrounding}{(Observed, Unobserved);}
#' \item{ExternalOperationalConditionsForSinking}{(Observed, Unobserved);}
#' \item{Fatigue}{(Yes, No);}
#' \item{Grounding}{(Yes, No);}
#' \item{HeavyWeatherAndSeaConditions}{(Yes, No);}
#' \item{InadequateManning}{(Yes, No);}
#' \item{InlandVessel}{(Yes, No);}
#' \item{InternalOperationalConditionsForCollisionAndContact}{(Observed, Unobserved);}
#' \item{InternalOperationalConditionsForGrounding}{(Observed, Unobserved);}
#' \item{InternalOperationalConditionsForSinking}{(Observed, Unobserved);}
#' \item{Malfunction}{(Observed, Unobserved);}
#' \item{ManoeuvreOfBridgeTeamMembers}{(Appropriate, Inappropriate);}
#' \item{ManoeuvreOfCaptain}{(Appropriate, Inappropriate);}
#' \item{ManoeuvreOfPilot}{(Appropriate, Inappropriate);}
#' \item{ManoeuvreOfWatchkeepingOfficer}{(Appropriate, Inappropriate);}
#' \item{NavigationArea}{(Narrow Water, Port, Coastal Water, Open Sea, Anchorage);}
#' \item{NavigationOnStorm}{(Yes, No);}
#' \item{ObservationDuringOperation}{(Clear, Unclear);}
#' \item{OversightAndControl}{(Adequate, Inadequate);}
#' \item{PilotOperationManagement}{(Safe, Unsafe);}
#' \item{PlannedMaintenance}{(Completed, Uncompleted);}
#' \item{PortCompanyPressure}{(Yes, No);}
#' \item{PortOperationManagement}{(Safe, Unsafe);}
#' \item{PortOperationPlanning}{(Adequate, Inadequate);}
#' \item{Procedure}{(Appropriate, Inappropriate);}
#' \item{Sinking}{(Yes, No);}
#' \item{SituationalAwareness}{(Sufficient, Insufficient);}
#' \item{TrainingAndFamiliarization}{(Sufficient, Insufficient);}
#' \item{TriggeringEventForCollisionAndContact}{(Observed, Unobserved);}
#' \item{TriggeringEventForGrounding}{(Observed, Unobserved);}
#' \item{TriggeringEventForSinking}{(Observed, Unobserved);}
#' \item{TugboatOperation}{(Operational, Faulty);}
#' \item{UseOfVesselInConditionOfExceedingDesignLimit}{(Yes, No);}
#' \item{VesselAge}{(Old, New);}
#' \item{VesselCargoOperationManagement}{(Safe, Unsafe);}
#' \item{VesselCargoOperationPlanning}{(Adequate, Inadequate);}
#' \item{VesselNavigationOperationManagement}{(Safe, Unsafe);}
#' \item{VesselNavigationOperationPlanning}{(Unsafe, Safe);}
#' \item{Visibility}{(Poor, Good);}
#'  }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Ugurlu, O., Yildiz, S., Loughney, S., Wang, J., Kuntchulia, S., & Sharabidze, I. (2020). Analyzing collision, grounding, and sinking accidents occurring in the Black Sea utilizing HFACS and Bayesian networks. Risk analysis, 40(12), 2610-2638.
"blacksea"
