% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_series_comparison.R
\name{plot_series_comparison}
\alias{plot_series_comparison}
\title{Compare multiple financial/time series indices}
\usage{
plot_series_comparison(
  data_list,
  y_vars,
  date_vars,
  language = "eng",
  scale_type = c("none", "index", "percent_change"),
  title = NULL,
  subtitle = NULL,
  y_label = NULL,
  caption = NULL,
  colors = NULL,
  line_types = NULL,
  show_legend = TRUE,
  legend_position = "bottom"
)
}
\arguments{
\item{data_list}{Named list of data frames, each returned by a get_* function}

\item{y_vars}{Vector of column names containing the values to plot from each data frame}

\item{date_vars}{Vector of column names containing dates from each data frame}

\item{language}{Language for labels: "pt" (Portuguese) or "eng" (English)}

\item{scale_type}{Type of scaling: "none" (raw values), "index" (index to 100),
"percent_change" (percentage change from first observation)}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{y_label}{Y-axis label}

\item{caption}{Plot caption}

\item{colors}{Vector of colors for each series}

\item{line_types}{Vector of line types for each series}

\item{show_legend}{Whether to show the legend (default: TRUE)}

\item{legend_position}{Position of legend ("bottom", "top", "left", "right", or "none")}
}
\value{
A ggplot2 object
}
\description{
Plots multiple time series on the same chart for comparison.
}
\examples{
\dontrun{
# Example comparing multiple series
selic <- get_selic_rate(2020, 2024)
ipca <- get_ipca(2020, 2024)
igpm <- get_igpm(2020, 2024)

comparison_plot <- plot_series_comparison(
  data_list = list(SELIC = selic, IPCA = ipca, IGP-M = igpm),
  y_vars = c("rate", "value", "value"),
  date_vars = c("date", "date", "date"),
  scale_type = "index",
  title = "Comparison of Brazilian Economic Indicators",
  y_label = "Index (2020-01 = 100)",
  language = "eng"
)
print(comparison_plot)
}
}
