% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakebase.R
\name{db_lakebase_creds_generate}
\alias{db_lakebase_creds_generate}
\title{Generate Database Credential}
\usage{
db_lakebase_creds_generate(
  instance_names,
  tables = NULL,
  permission_set = c("READ_ONLY"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{instance_names}{Character vector of database instance names to scope
the credential to.}

\item{tables}{Optional character vector of table names to scope the
credential to.}

\item{permission_set}{Permission set for the credential request. Currently
only \code{READ_ONLY} is supported.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
Generate Database Credential
}
\details{
An idempotency token is generated automatically for each request (UUID4-like
string).
}
\seealso{
Other Database API: 
\code{\link{db_lakebase_get}()},
\code{\link{db_lakebase_get_by_uid}()},
\code{\link{db_lakebase_list}()}
}
\concept{Database API}
