% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume-fs.R
\name{db_volume_write}
\alias{db_volume_write}
\title{Volume FileSystem Write}
\usage{
db_volume_write(
  path,
  file = NULL,
  overwrite = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE,
  progress = TRUE
)
}
\arguments{
\item{path}{Absolute path of the file in the Files API, omitting the initial
slash.}

\item{file}{Path to a file on local system, takes precedent over \code{path}.}

\item{overwrite}{Flag (Default: \code{FALSE}) that specifies whether to overwrite
existing files.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}

\item{progress}{If TRUE, show progress bar for file operations (default: TRUE for uploads/downloads, FALSE for other operations)}
}
\description{
Upload a file to volume filesystem.
}
\details{
Uploads a file of up to 5 GiB.
}
\seealso{
Other Volumes FileSystem API: 
\code{\link{db_volume_delete}()},
\code{\link{db_volume_dir_create}()},
\code{\link{db_volume_dir_delete}()},
\code{\link{db_volume_dir_exists}()},
\code{\link{db_volume_file_exists}()},
\code{\link{db_volume_list}()},
\code{\link{db_volume_read}()},
\code{\link{db_volume_upload_dir}()}
}
\concept{Volumes FileSystem API}
