% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url_uri.R
\name{bs_url_to_uri}
\alias{bs_url_to_uri}
\title{Convert Hypertext Transfer Protocol Secure URLs to Universal Resource Identifiers}
\usage{
bs_url_to_uri(
  url,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{url}{Character, length 1. URL for record to get.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
character vector of URIs
}
\description{
Convert Hypertext Transfer Protocol Secure URLs to Universal Resource Identifiers
}
\section{Function introduced}{

\code{v0.2.0} (2024-11-30)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_url_to_uri('https://bsky.app/profile/chriskenny.bsky.social/post/3lc5d6zspys2c')
\dontshow{\}) # examplesIf}
}
