% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job_log.R
\name{job_log}
\alias{job_log}
\title{Obtain Job log}
\usage{
job_log(job_id, print = TRUE, n_line = 10)
}
\arguments{
\item{job_id}{The job id. It can be a single job or a vector of job ids.}

\item{print}{Whether to print the log message to the terminal.}

\item{n_line}{Number of last lines for each job to show when multiple jobs are queried.}
}
\value{
The log messages as a vector.
}
\description{
Obtain Job log
}
\examples{
\dontrun{
# a single job
job_id = 1234567  # job ids can be get from `bjobs`
job_log(job_id)
# multiple jobs
job_id = c(10000000, 10000001, 10000002) 
job_log(job_id)  # by  default last 10 lines for each job are printed
job_log(job_id, n_line = 20) # print last 20 lines for each job
# logs for all running jobs
job_log()
}
}
