% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency.R
\name{job_dependency_all}
\alias{job_dependency_all}
\alias{job_dependency_igraph}
\alias{job_dependency_dot}
\alias{job_dependency_diagram}
\title{Job dependencies}
\usage{
job_dependency_all(job_tb = NULL)

job_dependency_igraph(job_id, job_tb = NULL)

job_dependency_dot(job_id, job_tb = NULL, use_label = FALSE, label_width = 15)

job_dependency_diagram(
  job_id,
  job_tb = NULL,
  use_label = FALSE,
  label_width = 15,
  ...
)
}
\arguments{
\item{job_tb}{A data frame from \code{\link[=bjobs]{bjobs()}}. Internally used.}

\item{job_id}{A single job ID.}

\item{use_label}{Whether to use job names on the diagram?}

\item{label_width}{Max number of characters for wrapping the label into lines.}

\item{...}{Pass to \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}, such as the size of the html widget.}
}
\value{
\code{job_dependency_all()} returns a list that contains three elements:
\itemize{
\item \code{dep_mat}: a two column matrix containing dependencies from parents to children.
\item \code{id2name}: a named vector containing mapping from job IDs to job names.
\item \code{id2stat}: a named vector containing mapping from job IDs to job status.
}

\code{job_dependency_igraph()} returns a \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} object which contains a dependency
graph induced by the input job ID.

\code{job_dependency_dot()} returns a DOT code for GraphViz visualization.

\code{job_dependency_diagram()} makes a HTML-based dependency diagram.
}
\description{
Job dependencies
}
\examples{
\dontrun{
job1 = random_job()
job2 = random_job()
job3 = random_job(dependency = c(job1, job2))

job_dependency_all()
job_dependency_igraph(job3)
cat(job_dependency_dot(job3))
job_dependency_diagram(job3)
}
}
