% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_design.R
\name{parse_design}
\alias{parse_design}
\title{Parse design data.frame}
\usage{
parse_design(df)
}
\arguments{
\item{df}{A \code{data.frame} of dimensions (groups) by (phases+1).}
}
\value{
A \linkS4class{CalmrDesign} object.
}
\description{
Parse design data.frame
}
\note{
Each entry in even-numbered columns of df is
a string formatted as per \code{\link[=phase_parser]{phase_parser()}}.
}
\examples{
df <- data.frame(
  Group = c("Group 1", "Group 2"),
  P1 = c("10AB(US)", "10A(US)")
)
parse_design(df)
}
\seealso{
\code{\link[=phase_parser]{phase_parser()}}
}
