% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{compare_models}
\alias{compare_models}
\title{Run models given a set of parameters}
\usage{
compare_models(x, models = NULL, ...)
}
\arguments{
\item{x}{A list of \linkS4class{CalmrExperiment} objects or a design \link{data.frame}.}

\item{models}{A character vector of length m, specifying the models to run.
Ignored if x is a list of \linkS4class{CalmrExperiment} objects.}

\item{...}{Arguments passed to \link{make_experiment}.}
}
\value{
A list of \linkS4class{CalmrExperiment} objects
}
\description{
Run models given a set of parameters
}
\examples{
# By making experiment beforehand (recommended)
df <- get_design("blocking")
models <- c("HD2022", "RW1972", "PKH1982")
exps <- lapply(models, function(m) {
  make_experiment(df,
    parameters = get_parameters(df, model = m),
    model = m
  )
})
comp <- compare_models(exps)

# By passing minimal arguments (not recommended; default parameters)
comp <- compare_models(df, models = models)
}
