% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_precommit.R
\name{create_precommit_hook}
\alias{create_precommit_hook}
\title{Create pre-commit hooks}
\usage{
create_precommit_hook(
  filename,
  id,
  name,
  description,
  language = "system",
  always_run = TRUE
)
}
\arguments{
\item{filename}{The name of script file}

\item{id}{The unique identifier for the hook}

\item{name}{A descriptive name for the hook}

\item{description}{A brief description of what the hook does}

\item{language}{The programming language or environment for the hook (default is "system")}

\item{always_run}{Logical, whether the hook should always run (default is TRUE)}
}
\value{
cli messages related to the creation of the hook and updating the config file. Create \verb{inst/pre-commit/hooks/\{filename\}.R} script and update \code{.pre-commit-config.y*ml} file.
}
\description{
Add pre-commit hooks to .pre-commit-config.y*ml file
}
