% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carts-package.R
\docType{package}
\name{carts-package}
\alias{carts-package}
\alias{carts}
\title{carts: Simulation-Based Assessment of Covariate Adjustment in Randomized Trials}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Monte Carlo simulation framework for different randomized clinical trial designs with a special emphasis on estimators based on covariate adjustment. The package implements regression-based covariate adjustment (Rosenblum & van der Laan (2010) \doi{10.2202/1557-4679.1138}) and a one-step estimator (Van Lancker et al (2024) \doi{10.48550/arXiv.2404.11150}) for trials with continuous, binary and count outcomes. The estimation of the minimum sample-size required to reach a specified statistical power for a given estimator uses bisection to find an initial rough estimate, followed by stochastic approximation (Robbins-Monro (1951) \doi{10.1214/aoms/1177729586}) to improve the estimate, and finally, a grid search to refine the estimate in the neighborhood of the current best solution.
}
\examples{
\donttest{
trial <- Trial$new(
  covariates = \(n) data.frame(a = rbinom(n, 1, 0.5), x = rnorm(n)),
  outcome = setargs(outcome_count, par = c(1, 0.5, 1), overdispersion = 0.7)
)

trial$estimators(
  unadjusted = est_glm(family = "poisson"),
  adjusted = est_glm(family = "poisson", covariates = "x")
)

trial$run(n = 200, R = 100)
trial$summary()
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://novonordisk-opensource.github.io/carts/}
  \item \url{https://github.com/NovoNordisk-OpenSource/carts}
  \item Report bugs at \url{https://github.com/NovoNordisk-OpenSource/carts/issues}
}

}
\author{
\strong{Maintainer}: Benedikt Sommer \email{benediktsommer92@gmail.com}

Authors:
\itemize{
  \item Klaus K. Holst \email{klaus@holst.it}
  \item Foroogh Shamsi \email{foroogh.shamsi1@gmail.com}
}

Other contributors:
\itemize{
  \item Novo Nordisk A/S [copyright holder]
}

}
\keyword{internal}
\keyword{package}
