% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tges.R
\name{tges}
\alias{tges}
\title{Estimate the restricted Markov equivalence class using Temporal Greedy Equivalence Search}
\usage{
tges(score, verbose = FALSE)
}
\arguments{
\item{score}{tiered scoring object to be used. At the moment only scores supported re \code{\linkS4class{TemporalBIC}} and \code{\linkS4class{TemporalBDeu}}.}

\item{verbose}{indicates whether debug output should be printed.}
}
\value{
\code{tges} returns a \code{tamat} object which is a matrix with a
"order" attribute (a character vector listing the temporal order of the variables in the adjacency matrix).
}
\description{
Perform causal discovery using the temporal greedy equivalence search algorithm.
}
\examples{
#Simulate Gaussian data
set.seed(123)
n <- 500
child_x <- rnorm(n)
child_y <- 0.5*child_x + rnorm(n)
child_z <- 2*child_x + child_y  + rnorm(n)

adult_x <- child_x + rnorm(n)
adult_z <- child_z + rnorm(n)
adult_w <- 2*adult_z + rnorm(n)
adult_y <- 2*child_x + adult_w + rnorm(n)

simdata <- data.frame(child_x, child_y, child_z,
                     adult_x, adult_z, adult_w,
                      adult_y)

# Define order in prefix way
prefix_order <- c("child", "adult")

# Define TBIC score
t_score <- new("TemporalBIC", order = prefix_order
               , data = simdata)
# Run tges
tges_pre <- tges(t_score)

# Plot MPDAG
plot(tges_pre)

# Define order in integer way
integer_order <- c(1,1,1,2,2,2,2)

# Define TBIC score
t_score <- new("TemporalBIC", order = integer_order
               , data = simdata)
# Run tges
tges_int <- tges(t_score)

# Plot MPDAG
plot(tges_int)

}
\seealso{
\code{\linkS4class{TemporalBIC}}
}
\author{
Tobias Ellegaard Larsen
}
