% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecca.r
\name{ecca}
\alias{ecca}
\title{Sparse Canonical Correlation via Reduced-Rank Regression when both X and Y are high-dimensional.}
\usage{
ecca(
  X,
  Y,
  lambda = 0,
  groups = NULL,
  Sx = NULL,
  Sy = NULL,
  Sxy = NULL,
  r = 2,
  standardize = FALSE,
  rho = 1,
  B0 = NULL,
  eps = 1e-04,
  maxiter = 500,
  verbose = TRUE
)
}
\arguments{
\item{X}{Predictor matrix (n x p)}

\item{Y}{Response matrix (n x q)}

\item{lambda}{Regularization parameter}

\item{groups}{List of index vectors defining groups of predictors}

\item{Sx}{precomputed covariance matrix for X (optional)}

\item{Sy}{precomputed covariance matrix for Y (optional)}

\item{Sxy}{precomputed covariance matrix between X and Y (optional)}

\item{r}{Target rank}

\item{standardize}{Whether to scale variables}

\item{rho}{ADMM parameter}

\item{B0}{Initial value for the coefficient matrix (optional)}

\item{eps}{Convergence threshold for ADMM}

\item{maxiter}{Maximum number of ADMM iterations}

\item{verbose}{Print diagnostics}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{cor}{Canonical covariances}
\item{loss}{The prediction error 1/n * \| XU - YV\|^2}
}
}
\description{
Performs group-sparse reduced-rank regression for CCA using either ADMM or CVXR solvers.
}
