% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{is_expanded}
\alias{is_expanded}
\title{Check Province Expansion Status}
\usage{
is_expanded(reg_code)
}
\arguments{
\item{reg_code}{non-harmonized province code (character or numeric).}
}
\value{
A logical value:
\itemize{
\item \code{TRUE} if the province is marked as expanded,
\item \code{FALSE} otherwise.
}
}
\description{
This function checks whether a given province code corresponds
to a province that has been expanded (i.e., administratively split
or modified).
}
\details{
The function looks up the internal dataset \code{prov_coverage}.
Expansion status is determined by the field \code{expanded}.
}
\examples{
# Example: check expansion status of a province
get_code_label(5) #returns list of non-harmonized province code
is_expanded(1400)   # returns TRUE/FALSE for Riau province

}
\seealso{
\code{\link[=get_code_label]{get_code_label()}}
}
