% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{find_local_maxima}
\alias{find_local_maxima}
\title{Find Local Maxima in Glucose Time Series}
\usage{
find_local_maxima(df)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}
}
\value{
A list containing:
\itemize{
  \item \code{local_maxima_vector}: Tibble with R-based (1-indexed) row numbers of local maxima (\code{local_maxima}). The corresponding occurrence time is \code{df$time[local_maxima]} and glucose is \code{df$gl[local_maxima]}.
  \item \code{merged_results}: Tibble with local maxima details (\code{id}, \code{time}, \code{gl})
}
}
\description{
Identifies local maxima (peaks) in glucose concentration time series data.
Uses a difference-based algorithm to detect peaks where glucose values
increase or remain constant for two consecutive points before the peak point,
and decrease or remain constant for two consecutive points after the peak point.
}
\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Find local maxima
maxima_result <- find_local_maxima(example_data_5_subject)
print(paste("Found", nrow(maxima_result$local_maxima_vector), "local maxima"))

# Find maxima on larger dataset
large_maxima <- find_local_maxima(example_data_hall)
print(paste("Found", nrow(large_maxima$local_maxima_vector), "local maxima in larger dataset"))

# View first few maxima
head(maxima_result$local_maxima_vector)

# View merged results
head(maxima_result$merged_results)
}
\seealso{
\link{grid}, \link{mod_grid}, \link{find_new_maxima}

Other GRID pipeline: 
\code{\link{detect_between_maxima}()},
\code{\link{find_max_after_hours}()},
\code{\link{find_max_before_hours}()},
\code{\link{find_min_after_hours}()},
\code{\link{find_min_before_hours}()},
\code{\link{find_new_maxima}()},
\code{\link{grid}()},
\code{\link{maxima_grid}()},
\code{\link{mod_grid}()},
\code{\link{start_finder}()},
\code{\link{transform_df}()}
}
\concept{GRID pipeline}
