% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{start_finder}
\alias{start_finder}
\title{Find Start Points for Event Analysis}
\usage{
start_finder(df)
}
\arguments{
\item{df}{A dataframe with the first column containing an integer vector of 0s and 1s}
}
\value{
A tibble containing start_indices with R-based (1-indexed) positions where episodes start
Note: These indices refer to positions in the provided input vector/dataframe, not necessarily rows of the original CGM \code{df} unless that vector was derived directly from \code{df} in row order.
}
\description{
Finds R-based (1-indexed) positions where the value is 1 in an integer vector 
of 0s and 1s, specifically identifying episode start points. This function 
looks for positions where a 1 follows a 0 or is at the beginning of the vector,
which is useful for identifying the start of glycemic events or episodes.
}
\section{Notes}{

- Returns R-based \code{start_indices} positions relative to the provided input vector/dataframe.
- If used on vectors derived from a CGM \code{df}, indices map directly to \code{df} rows.
}

\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Create a binary vector indicating episode starts
binary_vector <- c(0, 0, 1, 1, 0, 1, 0, 0, 1, 1)
df <- data.frame(episode_starts = binary_vector)

# Find R-based indices where episodes start
start_points <- start_finder(df)
print(paste("Start indices:", paste(start_points$start_indices, collapse = ", ")))

# Use with actual GRID results
grid_result <- grid(example_data_5_subject, gap = 15, threshold = 130)
grid_starts <- start_finder(grid_result$grid_vector)
print(paste("GRID episode starts:", length(grid_starts$start_indices)))

# Analysis on larger dataset
large_grid <- grid(example_data_hall, gap = 15, threshold = 130)
large_starts <- start_finder(large_grid$grid_vector)
print(paste("GRID episode starts in larger dataset:", length(large_starts$start_indices)))
}
\seealso{
\link{grid}, \link{mod_grid}

Other GRID pipeline: 
\code{\link{detect_between_maxima}()},
\code{\link{find_local_maxima}()},
\code{\link{find_max_after_hours}()},
\code{\link{find_max_before_hours}()},
\code{\link{find_min_after_hours}()},
\code{\link{find_min_before_hours}()},
\code{\link{find_new_maxima}()},
\code{\link{grid}()},
\code{\link{maxima_grid}()},
\code{\link{mod_grid}()},
\code{\link{transform_df}()}
}
\concept{GRID pipeline}
