% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat4R.R
\name{chat4R}
\alias{chat4R}
\title{Chat4R: Interact with gpt-4o-mini (default) using OpenAI API}
\usage{
chat4R(
  content,
  Model = "gpt-4o-mini",
  temperature = 1,
  simple = TRUE,
  fromJSON_parsed = FALSE,
  check = FALSE,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{content}{A string containing the user's input message.}

\item{Model}{A string specifying the GPT model to use (default: "gpt-4o-mini").}

\item{temperature}{A numeric value controlling the randomness of the model's output (default: 1).}

\item{simple}{Logical, if TRUE, only the content of the model's message will be returned.}

\item{fromJSON_parsed}{Logical, if TRUE, content will be parsed from JSON.}

\item{check}{Logical, if TRUE, prints detailed error information (message, type, param, code) if the API response includes an error.
If there is no error, "No error" is printed.}

\item{api_key}{A string containing the user's OpenAI API key.
Defaults to the value of the environment variable "OPENAI_API_KEY".}
}
\value{
A data frame or list containing the response from the GPT model, depending on arguments.
}
\description{
This function uses the OpenAI API to interact with the
   gpt-4o-mini model (default) and generates responses based on user input.
   In this function, currently, "gpt-4o-mini" (default), "gpt-4o", "gpt-4",
   and "gpt-4-turbo"
   can be selected as OpenAI's LLM model.
}
\details{
Chat4R Function
}
\examples{
\dontrun{
Sys.setenv(OPENAI_API_KEY = "Your API key")
chat4R(content = "What is the capital of France?", check = TRUE)

}
}
\author{
Satoshi Kume
}
