% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rel_change_scenario.R
\name{gen_rel_change_scenario}
\alias{gen_rel_change_scenario}
\title{Generates relative climate change scenarios based on extracted CMIP6 data}
\usage{
gen_rel_change_scenario(
  downloaded_list,
  scenarios = c(2050, 2085),
  reference_period = c(1986:2014),
  future_window_width = 30
)
}
\arguments{
\item{downloaded_list}{list of data.frames, generated using the
extract_cmip6_data function. Elements are named after the shared socioeconomic
pathway ('SSP') and global climate model ('GCM')}

\item{scenarios}{numeric vector, states the future years, for which the climate
change scenarios should be generated. By default set to c(2050, 2085).}

\item{reference_period}{numeric vector specifying the years to be used as the
reference period. Defaults to c(1986:2014).}

\item{future_window_width}{numeric, sets the window width of the running mean
calculation for the mean temperatures of the years indicated by scenarios}
}
\value{
data.frame for the calculated relative change scenarios, all locations, SSPs, timepoints, GCMs combined
}
\description{
Takes the extracted CMIP6 data and returns climate change scenarios, which
can then be used to generate weather data.
}
\examples{
\dontrun{
download_cmip6_ecmwfr(scenario = 'ssp1_2_6', 
                      area = c(55, 5.5, 47, 15.1),
                      user = 'write user id here',
                      key = 'write key here',
                      model = 'AWI-CM-1-1-MR',
                      frequency = 'monthly', 
                      variable = c('Tmin', 'Tmax'),
                      year_start = 2015, 
                      year_end = 2100)
                      
download_baseline_cmip6_ecmwfr(
    area = c(55, 5.5, 47, 15.1),
    user = 'write user id here',
    key = 'write key here',
    model = 'AWI-CM-1-1-MR',
    frequency = 'monthly', 
   
station <- data.frame(
      station_name = c('Zaragoza', 'Klein-Altendorf', 'Sfax',
      'Cieza', 'Meknes', 'Santomera'),
      longitude = c(-0.88,  6.99, 10.75, -1.41, -5.54, -1.05),
      latitude = c(41.65, 50.61, 34.75, 38.24, 33.88, 38.06))
      
extracted <- extract_cmip6_data(stations = station)

gen_rel_change_scenario(extracted)

}

}
\author{
Lars Caspersen
}
