% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gcms.R
\name{dist_gcms}
\alias{dist_gcms}
\title{Distance Between GCMs}
\usage{
dist_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  method = "euclidean"
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to compare, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted. Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Whether to apply centering and scaling to the data. Default is \code{TRUE}.}

\item{method}{Character. The correlation method to use. Default is "euclidean". Possible values are: "euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski", "pearson", "spearman", or "kendall".}
}
\value{
A list containing two items: \code{distances} (the calculated distances between GCMs) and \code{heatmap} (a plot displaying the heatmap).
}
\description{
This function compares future climate projections from multiple General Circulation Models (GCMs) based on their similarity in terms of variables. It calculates distance metrics and plots the results on a heatmap.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
dist_gcms(s, var_names, study_area, method = "euclidean")

}
\seealso{
\code{\link{transform_gcms}} \code{\link{flatten_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
