% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_gcms.R
\name{summary_gcms}
\alias{summary_gcms}
\title{Summarize General Circulation Model (GCM) Data}
\usage{
summary_gcms(s, var_names = c("bio_1", "bio_12"), study_area = NULL)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to include, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted.
Defines the study area for cropping and masking the rasters.}
}
\value{
A data frame containing the summary statistics for each variable.
}
\description{
This function summarizes GCM data by calculating various statistics for each variable.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
summary_gcms(s, var_names, study_area)

}
\seealso{
\code{\link{transform_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
