% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cif-stat-arguments.R
\name{cif-stat-arguments}
\alias{cif-stat-arguments}
\title{These arguments are shared by \code{\link[=cifplot]{cifplot()}}, \code{\link[=cifpanel]{cifpanel()}}, and
\code{\link[=cifcurve]{cifcurve()}}.}
\arguments{
\item{data}{A data frame containing variables in the formula.}

\item{weights}{Optional name of the weight variable in \code{data}. Weights must be nonnegative.}

\item{subset.condition}{Optional character string giving a logical condition to subset
\code{data} (default \code{NULL}).}

\item{na.action}{A function specifying the action to take on missing values (default \code{na.omit}).}

\item{outcome.type}{Character string specifying the type of time-to-event outcome.
One of \code{"survival"} (Kaplan-Meier) or \code{"competing-risk"} (Aalen-Johansen).
If \code{NULL} (default), the function automatically infers the outcome type from the data:
if the event variable has more than two unique levels, \code{"competing-risk"} is assumed;
otherwise, \code{"survival"} is used. You can also use abbreviations such as \code{"S"} or \code{"C"}.
Mixed or ambiguous inputs (e.g., \code{c("S", "C")}) trigger automatic detection based on the event coding.}

\item{code.event1}{Integer code of the event of interest (default \code{1}).}

\item{code.event2}{Integer code of the competing risk (default \code{2}).}

\item{code.censoring}{Integer code of censoring (default \code{0}).}

\item{error}{Character string specifying the method for SEs and CIs used internally.
For \code{"survival"} without weights, choose one of \code{"greenwood"} (default), \code{"tsiatis"}, or \code{"if"}.
For \code{"competing-risk"} without weights, choose one of \code{"delta"} (default), \code{"aalen"}, or \code{"if"}.
SEs and CIs based on influence functions (\code{"if"}) is recommended for weighted analysis.}

\item{conf.type}{Character specifying the method of transformation for CIs
used internally (default \verb{arcsine-square root}).}

\item{conf.int}{Numeric two-sided level of CIs (default \code{0.95}).}
}
\description{
These arguments are shared by \code{\link[=cifplot]{cifplot()}}, \code{\link[=cifpanel]{cifpanel()}}, and
\code{\link[=cifcurve]{cifcurve()}}.
}
\keyword{internal}
