// a rudimentary Atomic64 type for enabling safe-ish storing
// of module level configuration parameters, notably INFINITY.
//
// See: https://github.com/rust-lang/rust/issues/72353

use std::sync::atomic::AtomicU64;
pub use std::sync::atomic::Ordering;

pub struct AtomicF64 {
    storage: AtomicU64,
}
impl AtomicF64 {
    pub fn new(value: f64) -> Self {
        let as_u64 = value.to_bits();
        Self {
            storage: AtomicU64::new(as_u64),
        }
    }
    pub fn store(&self, value: f64, ordering: Ordering) {
        let as_u64 = value.to_bits();
        self.storage.store(as_u64, ordering);
    }
    pub fn load(&self, ordering: Ordering) -> f64 {
        let as_u64 = self.storage.load(ordering);
        f64::from_bits(as_u64)
    }
}
