% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\encoding{UTF-8}
\name{get_network}
\alias{get_network}
\title{Extract a \code{coglasso} network}
\usage{
get_network(sel_cg_obj, index_c = NULL, index_lw = NULL, index_lb = NULL)
}
\arguments{
\item{sel_cg_obj}{The object of \code{S3} class \code{select_coglasso} or of \code{S3}
class \code{coglasso}.}

\item{index_c}{The index of the \eqn{c} value different from the one
selected by model selection. To set only if the desired network is not the
selected one.}

\item{index_lw}{The index of the \eqn{\lambda_w} value of the chosen
non-optimal network. To set only if the desired network is not the
selected one.}

\item{index_lb}{The index of the \eqn{\lambda_b} value of the chosen
non-optimal network. To set only if the desired network is not the
selected one.}
}
\value{
\code{get_network()} returns the selected network, in the form of an
object of class \code{igraph}.
}
\description{
\code{get_network()} extracts the selected network from a \code{select_coglasso} object,
or a different specific one from either a \code{select_coglasso} or a \code{coglasso}
object when specifying the optional parameters.
}
\details{
If the input is a \code{coglasso} object, it is necessary to specify all the
indexes to extract the chosen network. \cr
If the input is a \code{select_coglasso} object, it extracts by default the
selected network. If the selection method was "ebic", and you want to extract
a different network than the selected one, specify all indexes.
Otherwise, if the objective is to extract the optimal network for a specific
\eqn{c} value different than the selected one, set \code{index_c} to your chosen
one. Also here it is possible to extract a specific non-optimal network by
setting all the indexes to the chosen ones.
}
\examples{
\donttest{
sel_cg <- bs(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, nlambda_b = 3,
                 nc = 3, verbose = FALSE)
sel_net <- get_network(sel_cg)
# Could even plot the selected network with plot(sel_net), but then it would
# plot an unnotated network, better to directly plot(sel_cg).
print(sel_net)
}

}
