% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XStARS.R
\name{xstars}
\alias{xstars}
\title{Stability selection of the best \code{coglasso} network}
\usage{
xstars(
  coglasso_obj,
  stars_thresh = 0.1,
  stars_subsample_ratio = NULL,
  rep_num = 20,
  max_iter = 10,
  verbose = TRUE
)
}
\arguments{
\item{coglasso_obj}{The object of \code{S3} class \code{coglasso} returned by \code{coglasso()}.}

\item{stars_thresh}{The threshold set for variability of the explored
networks at each iteration of the algorithm. The \eqn{\lambda_w} or the \eqn{\lambda_b}
associated to the most stable network before the threshold is overcome is
selected.}

\item{stars_subsample_ratio}{The proportion of samples in the multi-omics
data set to be randomly subsampled to estimate the variability of the
network under the given hyperparameters setting. Defaults to 80\% when the
number of samples is smaller than 144, otherwise it defaults to
\eqn{\frac{10}{n}\sqrt{n}}.}

\item{rep_num}{The amount of subsamples of the multi-omics data set used to
estimate the variability of the network under the given hyperparameters
setting. Defaults to 20.}

\item{max_iter}{The greatest number of times the algorithm is allowed to
choose a new best \eqn{\lambda_w}. Defaults to 10.}

\item{verbose}{Print information regarding the progress of the selection
procedure on the console.}
}
\value{
\code{xstars()} returns an object of \code{S3} class \code{select_coglasso}
containing the results of the
selection procedure, built upon the object of \code{S3} class \code{coglasso} returned by \code{coglasso()}.
\itemize{
\item ... are the same elements returned by \code{\link[=coglasso]{coglasso()}}.
\item \code{merge} is the "merged" adjacency matrix, the average of all the adjacency
matrices estimated across all the different subsamples for the selected
combination of \eqn{\lambda_w}, \eqn{\lambda_b}, and \eqn{c} values in the
last path explored before convergence. Each entry is a measure of how
recurrent the corresponding edge is across the subsamples.
\item \code{variability_lw}, \code{variability_lb} and \code{variability_c} are numeric vectors
of as many items as the number of \eqn{\lambda_w}, \eqn{\lambda_b}, and
\eqn{c} values explored. Each item is the variability of the network
estimated for the corresponding hyperparameter value, keeping the other two
hyperparameters fixed to their selected value.
\item \code{sel_index_c}, \code{sel_index_lw} and \code{sel_index_lb} are the indexes of the
final selected parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b}
leading to the most stable sparse network.
\item \code{sel_c}, \code{sel_lambda_w} and \code{sel_lambda_b} are the final selected
hyperparameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the
most stable sparse network.
\item \code{sel_adj} is the adjacency matrix of the final selected network.
\item \code{sel_variability} is the variability of the final selected network.
\item \code{sel_density} is the density of the final selected network.
\item \code{sel_icov} is the inverse covariance matrix of the final selected network.
\item \code{sel_cov} optional, given only when \code{coglasso()} was called with
\code{cov_output = TRUE}. It is the covariance matrix associated with the final
selected network.
\item \code{call} is the matched call.
\item \code{method} is the chosen model selection method. Here, it is "xstars".
}
}
\description{
\code{xstars()} selects the combination of hyperparameters given to
\code{coglasso()} yielding the most stable, yet sparse network. Stability is
computed upon network estimation from multiple subsamples of the multi-omics data set,
allowing repetition. Subsamples are collected for a fixed amount of times
(\code{rep_num}), and with a fixed proportion of the total number of samples
(\code{stars_subsample_ratio}).
}
\details{
\emph{eXtended StARS} (\emph{XStARS}) is an adaptation for \emph{collaborative graphical regression} of the method
published by Liu, H. \emph{et al.} (2010): Stability Approach to Regularization
Selection (StARS). \emph{StARS} was developed for network estimation regulated by
a single penalty parameter, while \emph{collaborative graphical lasso} needs to
explore three different hyperparameters. These all have, to a different
degree, a direct influence on network sparsity, hence on stability. For every
iteration, \code{xstars()} explores one of the three parameters (\eqn{\lambda_w},
\eqn{\lambda_b}, or \eqn{c}), keeping the other ones fixed at their previous
selected estimate, using the normal, one-dimentional \emph{StARS} approach, until
finding the best combination of the three that yields the most stable, yet
sparse network.
}
\examples{
cg <- coglasso(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, 
               nlambda_b = 3, nc = 3, verbose = FALSE)
\donttest{
# Takes around one minute
sel_cg <- xstars(cg, verbose = FALSE)
}
}
