% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%le\%}
\alias{\%le\%}
\title{Perform less than or equal comparison between two objects}
\usage{
x1 \%le\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value indicating the results of the comparison.
}
\description{
The goal of the comparison operators is to return a TRUE
or FALSE value when any two objects are compared.  The operators provides a
simple, reliable equality check that allows comparing
of NULLs, NA values, and atomic data types without error. This operator
performs a less than or equal to comparison.

For data frames, the operator will compare all values in all columns, and return
a single TRUE if all values in the second data frame are less than or equal to
the corresponding values in the first data frame.
}
\details{
Additional details...
}
\examples{
# Comparing of NULLs and NA
NULL \%le\% NULL        # TRUE
NULL \%le\% NA          # FALSE
NA \%le\% NA            # TRUE
1 \%le\% NULL           # FALSE
1 \%le\% NA             # FALSE

# Comparing of atomic values
1 \%le\% 1              # TRUE
2 \%le\% 1              # FALSE
1 \%le\% 2              # TRUE
"one" \%le\% "one"      # TRUE
1 \%le\% "one"          # FALSE
1 \%le\% Sys.Date()     # TRUE  (Sys.Date() is a number)

# Comparing of vectors
v1 <- c(0, 1, 2)
v2 <- c(1, 2, 3)
v3 <- c(2, 3, 4)
v1 \%le\% v1            # TRUE
v1 \%le\% v2            # TRUE
v2 \%le\% v1            # FALSE
v2 \%le\% v3            # TRUE

# Comparing of data frames
d1 <- data.frame(A = v1, B = v2)
d2 <- data.frame(A = v2, B = v3)
d1 \%le\% d1            # TRUE
d1 \%le\% d2            # TRUE
d2 \%le\% d1            # FALSE

# Mixing it up
d1 \%le\% NULL          # FALSE
v1 \%le\% d1            # FALSE
1 \%le\% v1             # FALSE
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%ge\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%ne\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
