% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomination.R
\name{cong_nomination}
\alias{cong_nomination}
\title{Request Nomination Information}
\usage{
cong_nomination(
  congress = NULL,
  number = NULL,
  item = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{number}{Nomination assigned number. Numeric.}

\item{item}{Information to request. Can be \code{'actions'}, \code{'committees'}, '\verb{hearings'} or the ordinal number.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
a \code{tibble::tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Nomination Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_nomination()

cong_nomination(congress = 118)

cong_nomination(congress = 117, number = 2467)

cong_nomination(congress = 117, number = 2467, item = 'actions')

cong_nomination(congress = 117, number = 2467, item = 1)
\dontshow{\}) # examplesIf}
}
