% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgrestiCaffo_CI_2x2.R
\name{AgrestiCaffo_CI_2x2}
\alias{AgrestiCaffo_CI_2x2}
\title{The Agresti-Caffo confidence interval for the difference between probabilities}
\usage{
AgrestiCaffo_CI_2x2(n, alpha = 0.05)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Agresti-Caffo confidence interval for the difference between probabilities

Described in Chapter 4 "The 2x2 Table"
}
\section{Table orientation}{
 In most study designs, rows designate a grouping of the data, for
instance, into treatment or exposure groups, while the columns indicate a
dichotomous outcome, usually with the first column representing the outcome
of interest. This designation of rows and columns may not be relevant in all
study designs, please see the introduction to chapter 4 for details.
}

\examples{
AgrestiCaffo_CI_2x2(perondi_2004)
AgrestiCaffo_CI_2x2(ritland_2007)
}
