% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse_contrasts.R
\name{glimpse_contrasts}
\alias{glimpse_contrasts}
\title{Get quick summary of contrasts in dataframe}
\usage{
glimpse_contrasts(
  model_data,
  ...,
  return_list = FALSE,
  show_all_factors = TRUE,
  add_namespace = FALSE,
  show_one_level_factors = FALSE,
  minimal = TRUE,
  verbose = getOption("contrastable.verbose"),
  .droplevels = getOption("contrastable.droplevels")
)
}
\arguments{
\item{model_data}{Data to be passed to a model fitting function}

\item{...}{Series of formulas}

\item{return_list}{Logical, defaults to FALSE, whether the output of
enlist_contrasts should be returned}

\item{show_all_factors}{Logical, defaults to TRUE, whether the factors not
explicitly set with formulas should be included}

\item{add_namespace}{Logical, defaults to FALSE, whether to append the
namespace of the contrast scheme to the scheme name}

\item{show_one_level_factors}{Logical, should factors with only one level be
included in the output? Default is FALSE to omit}

\item{minimal}{Logical, default TRUE, whether to omit the orthogonal,
centered, dropped_trends, and explicitly_set columns from the output table}

\item{verbose}{Logical, defaults to TRUE, whether messages should be printed}

\item{.droplevels}{Logical, defaults to TRUE, whether missing levels from
existing factor columns should be dropped before applying new contrasts. See
\code{Options("contrastable.droplevels")}}
}
\value{
A dataframe if return.list is FALSE, a list with a dataframe and list
of named contrasts if TRUE.
}
\description{
Uses the same syntax as \code{\link[=enlist_contrasts]{enlist_contrasts()}} and
\code{\link[=set_contrasts]{set_contrasts()}}. Returns a summary table of the contrasts you've set. If
you set \code{return.list=TRUE} then you can access a list of contrasts in the
second element of the resulting list. The glimpse dataframe is the first
element. \code{FALSE} will return just the glimpse data frame.
}
\details{
Generally, \code{glimpse_contrasts} will give warnings about mismatches between
the specified contrasts and what's actually set on the factors in a
dataframe. The warnings will typically tell you how to resolve these
mismatches. See the \code{contrasts} and \code{warnings} vignettes for more
information.
}
\examples{

my_contrasts <- list(cyl ~ sum_code, carb ~ helmert_code)
my_data <- set_contrasts(mtcars, my_contrasts, verbose = FALSE)
my_data$gear <- factor(my_data$gear) # Make gear a factor manually

# View information about contrasts; gear will use default for unordered
glimpse_contrasts(my_data, my_contrasts)
}
\seealso{
\code{\link[=enlist_contrasts]{enlist_contrasts()}} \code{\link[=set_contrasts]{set_contrasts()}}
}
