% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emissions_soil.R
\name{calc_emissions_soil}
\alias{calc_emissions_soil}
\title{Calculate soil N2O emissions}
\usage{
calc_emissions_soil(
  n_fertilizer_synthetic = 0,
  n_fertilizer_organic = 0,
  n_excreta_pasture = 0,
  n_crop_residues = 0,
  area_ha = NULL,
  soil_type = "well_drained",
  climate = "temperate",
  ef_direct = NULL,
  include_indirect = TRUE,
  gwp_n2o = 273,
  boundaries = NULL
)
}
\arguments{
\item{n_fertilizer_synthetic}{Numeric. Synthetic N fertiliser applied (kg N/year). Default = 0.}

\item{n_fertilizer_organic}{Numeric. Organic N fertiliser applied (kg N/year). Default = 0.}

\item{n_excreta_pasture}{Numeric. N excreted directly on pasture (kg N/year). Default = 0.}

\item{n_crop_residues}{Numeric. N in crop residues returned to soil (kg N/year). Default = 0.}

\item{area_ha}{Numeric. Total farm area (ha). Optional, for per-hectare metrics.}

\item{soil_type}{Character. "well_drained" or "poorly_drained". Default = "well_drained".}

\item{climate}{Character. "temperate" or "tropical". Default = "temperate".}

\item{ef_direct}{Numeric. Direct EF for N2O-N (kg N2O-N per kg N input).
If NULL, uses IPCC-style values by soil/climate.}

\item{include_indirect}{Logical. Include indirect N2O (volatilisation + leaching)? Default = TRUE.}

\item{gwp_n2o}{Numeric. GWP of N2O. Default = 273 (IPCC AR6).}

\item{boundaries}{Optional. Object from \code{set_system_boundaries()}.
If soil is excluded, returns \code{co2eq_kg = 0}.}
}
\value{
A list with at least \code{source="soil"} and \code{co2eq_kg} (numeric),
plus detailed breakdown metadata when included by boundaries.
}
\description{
Estimates direct and indirect N2O emissions from soils due to fertilisation,
excreta deposition and crop residues, following a Tier 1-style IPCC approach.
}
\details{
IMPORTANT: When system boundaries exclude soil, this function must return
a list with \code{source = "soil"} and \code{co2eq_kg = 0} (numeric zero) to match
partial-boundaries integration tests.

Direct and indirect factors used here are Tier 1-style defaults for examples
and screening. For inventories or policy reporting, replace them with
jurisdiction-specific values and methods.
}
\examples{
# Minimal, fast example (runs <1s): direct + indirect by default
calc_emissions_soil(
  n_fertilizer_synthetic = 500,
  n_fertilizer_organic   = 100
)

\donttest{
# Direct + indirect (default), temperate, well-drained
calc_emissions_soil(
  n_fertilizer_synthetic = 2500,
  n_fertilizer_organic   = 500,
  n_excreta_pasture      = 1200,
  n_crop_residues        = 300,
  area_ha                = 150
)

# Direct-only
calc_emissions_soil(n_fertilizer_synthetic = 2000, include_indirect = FALSE)

# Boundaries exclusion example: "soil" not included -> co2eq_kg = 0
b <- list(include = c("energy", "manure"))  # soil excluded
calc_emissions_soil(n_fertilizer_synthetic = 1000, boundaries = b)$co2eq_kg  # 0
}
}
\references{
Intergovernmental Panel on Climate Change (2019). 2019 Refinement to the 2006
IPCC Guidelines for National Greenhouse Gas Inventories.
\url{https://www.ipcc-nggip.iges.or.jp/public/2019rf/}

International Dairy Federation (2022). "The IDF Global Carbon Footprint Standard
for the Dairy Sector." Bulletin of the IDF No. 520. \url{https://fil-idf.org/}
}
