% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{Backfill-class}
\alias{Backfill-class}
\alias{.Backfill}
\alias{Backfill}
\alias{.DefaultBackfill}
\title{\code{Backfill} class}
\usage{
Backfill(
  cohort_size = CohortSizeConst(size = 3),
  opening = OpeningMinDose(),
  recruitment = RecruitmentUnlimited(),
  max_size = 1000000L,
  priority = c("highest", "lowest", "random")
)

.DefaultBackfill()
}
\arguments{
\item{cohort_size}{(\code{CohortSize})\cr see the slot definition.}

\item{opening}{(\code{Opening})\cr see the slot definition.}

\item{recruitment}{(\code{Recruitment})\cr see the slot definition.}

\item{max_size}{(\code{count})\cr see the slot definition.}

\item{priority}{(\code{character})\cr see the slot definition.}
}
\value{
An object of class \code{Backfill}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Class representing a backfilling rule in a clinical trial design.
}
\section{Slots}{

\describe{
\item{\code{cohort_size}}{(\code{CohortSize})\cr the size of cohorts to be backfilled.}

\item{\code{opening}}{(\code{Opening})\cr the opening criteria for backfilling.}

\item{\code{recruitment}}{(\code{Recruitment})\cr recruitment criteria for backfilling.}

\item{\code{max_size}}{(\code{count})\cr the maximum number of patients to be backfilled.}

\item{\code{priority}}{(\code{character})\cr the priority rule for backfilling,
one of "highest", "lowest", or "random".}
}}

\note{
Typically, end users will not use the \code{.DefaultBackfill()} function.
}
