% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{RecruitmentUnlimited-class}
\alias{RecruitmentUnlimited-class}
\alias{.RecruitmentUnlimited}
\alias{RecruitmentUnlimited}
\alias{.DefaultRecruitmentUnlimited}
\title{\code{RecruitmentUnlimited}}
\usage{
RecruitmentUnlimited()

.DefaultRecruitmentUnlimited()
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{RecruitmentUnlimited}} allows unlimited recruitment of backfill patients.
There is no constraint on the number of backfill patients relative to the
main trial cohort size.
}
\note{
Typically, end users will not use the \code{.DefaultRecruitmentUnlimited()} function.
}
\examples{
# Create a RecruitmentUnlimited object
recruitment <- RecruitmentUnlimited()
print(recruitment)

# Calculate maximum recruits for an active cohort of size 10
max_recruits <- maxRecruits(recruitment, active_cohort_size = 10)
print(max_recruits) # Practically unlimited (1e6)
}
\seealso{
\code{\link{Recruitment}} and the other subclasses listed in there.
}
